import java.util.Scanner;

public class Danca {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        while (true) {
            // Lê os valores de l, c e t
            int l = scanner.nextInt();
            int c = scanner.nextInt();
            int t = scanner.nextInt();

            if (l == 0 && c == 0 && t == 0) {
                break;
            }

            // Cria a matriz original
            int[][] original = new int[l][c];
            for (int i = 0; i < l; i++) {
                for (int j = 0; j < c; j++) {
                    original[i][j] = c * i + j + 1;
                }
            }

            // Arrays para controlar linhas e colunas
            int[] linha = new int[l];
            int[] coluna = new int[c];
            for (int i = 0; i < l; i++) {
                linha[i] = i;
            }
            for (int j = 0; j < c; j++) {
                coluna[j] = j;
            }

            // Processa as operações
            for (int opCount = 0; opCount < t; opCount++) {
                String op = scanner.next();
                int a = scanner.nextInt() - 1;
                int b = scanner.nextInt() - 1;

                if (op.equals("L")) {
                    int aux = linha[a];
                    linha[a] = linha[b];
                    linha[b] = aux;
                } else {
                    int aux = coluna[a];
                    coluna[a] = coluna[b];
                    coluna[b] = aux;
                }
            }

            // Gera a resposta
            int[][] resposta = new int[l][c];
            for (int i = 0; i < l; i++) {
                for (int j = 0; j < c; j++) {
                    resposta[i][j] = original[linha[i]][coluna[j]];
                }
            }

            // Imprime a resposta
            for (int i = 0; i < l; i++) {
                for (int j = 0; j < c; j++) {
                    System.out.print(resposta[i][j] + (j == c - 1 ? "\n" : " "));
                }
            }
        }

        scanner.close();
    }
}
